/*Codice SAS per riprodurre la relazione fra il Value at Risk delle distribuzioni di probabilit della Loss di un portafoglio e la correlazione di default ?*/
ods html close; 
ods html;
proc iml;

N=100;
pd=0.4;
p0=pd;
epsilon = 1E-6;
alphaVaR = 0.95-epsilon;
LB= (pd-1)/pd;
if pd<0.5 then LB=1/LB;
print LB;

epsilon1 = 0.01/2;
LB = LB+epsilon1;
print LB;

/* Salviamo questi valori in macrovariabili */
CALL SYMPUTX("N", N);
CALL SYMPUTX("PD", pd);
free vars;
free allpdf; /*inizializzazione della matrice allpdf*/
do ro= LB to 0.99 by .01; 
	I=pd*(1-pd);
	L=p0*(1-p0);
	q=(sqrt(I)*sqrt(L)*ro)+(pd*p0);
	D=(pd-q)/(1-p0-pd+q);
	E=(q/(p0-q))*((1-p0-pd+q)/(pd-q));
	F=(1-p0)/p0;
	G=(p0-q)/(1-p0-pd+q);

	alpha=log(D);
	alphazero=((N-1)*log(F))+(N*log(G));
	beta= log(E);
	H=alpha+beta;
	Z=((1+exp(alpha))##N) + ( exp(alphazero)*(1+exp(H))##N );
	somma_pdf=j(N+1,3,.);
	do ll=0 to N;
		coeff_bin= comb(N, ll);
		A= 1/Z;
		B= alpha * ll;
		C= alphazero + (ll*(alpha + beta));
		exp_B = exp(B);
		exp_C = exp(C);
		somma_pdf[ll+1,1]=ll; 
		somma_pdf[ll+1,2] = A * coeff_bin * (exp_B + exp_C); 
		somma_pdf[ll+1,3]=ro;
	end;
    pmf=somma_pdf[,2];
    CU = cusum(pmf);
    tmp = loc(CU >= alphaVaR);
    x = somma_pdf[,1];
    var = x[tmp[1]];
    vars = vars//(ro||var);
allpdf=allpdf//somma_pdf; 

end; /*end del ciclo rho*/
lossNorm=allpdf[,1]/N*100; 
allpdf=allpdf||lossNorm; 
create plt_pdf from allpdf[colname={"somma" "pdf" "rho" "lossnorm"}]; 
append from allpdf; 
close plt_pdf; /* Chiusura del dataset */
create plt_var from vars[colname={"rho" "var"}]; 
append from vars; 
close plt_var; /* Chiusura del dataset */
quit;

data plt_var;
set plt_var;
run;
proc capability data=plt_var;
comphist var;
run;
proc print data=plt_var(where =(rho<-0.66 | rho>0.98 | abs(rho)<0.005));
run;
proc sgplot data=plt_var;
scatter x=rho y=VaR; /* Traccia il grafico a LINEE*/
title "VaR e Correlazione  N=&N PD=&PD";

run;
